# SQLite to MySQL Migration Guide

This guide explains how to migrate your Project Management application from SQLite to MySQL.

## Changes Made

### 1. Updated Database Configuration
- Modified [config/database.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/config/database.js) to use MySQL as the primary database
- Updated connection pool initialization for MySQL
- Removed SQLite-specific code

### 2. Updated Route Files
All route files were updated to use the generic database module instead of the SQLite-specific one:
- [middleware/auth.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/middleware/auth.js)
- [routes/companies.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/routes/companies.js)
- [routes/permissions.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/routes/permissions.js)
- [routes/project_users.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/routes/project_users.js)
- [routes/projects.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/routes/projects.js)
- [routes/users.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/routes/users.js)
- [services/authService.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/services/authService.js)

### 3. SQL Syntax Updates
Updated SQLite-specific SQL syntax to be MySQL-compatible:
- Replaced `datetime('now')` with `NOW()`
- Replaced `datetime('now', '-30 days')` with `DATE_SUB(NOW(), INTERVAL 30 DAY)`
- Replaced `INSERT OR IGNORE` with `INSERT IGNORE` where appropriate

### 4. Created Migration Scripts
- [scripts/migrate-sqlite-to-mysql.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/scripts/migrate-sqlite-to-mysql.js) - Main migration script to transfer data from SQLite to MySQL
- [scripts/test-mysql-connection.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/scripts/test-mysql-connection.js) - Test MySQL connectivity
- [scripts/test-migration.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/scripts/test-migration.js) - Test the migration process

## Prerequisites

1. MySQL server installed and running
2. MySQL database created (default name: `project_management`)
3. Proper credentials configured in `.env` file

## Migration Steps

### 1. Configure Environment Variables
Update your `.env` file with MySQL connection details:

```env
# Database Configuration
DB_HOST=localhost
DB_PORT=3306
DB_NAME=project_management
DB_USER=your_mysql_username
DB_PASSWORD=your_mysql_password
```

### 2. Create Database Schema
Run the initial migration to create the database schema:

```bash
npm run migrate
```

### 3. Migrate Data from SQLite to MySQL
If you have existing data in SQLite that you want to migrate to MySQL:

```bash
npm run migrate-sqlite-to-mysql
```

### 4. Test the Application
Start the server and verify everything works correctly:

```bash
npm start
```

## Testing

### Test MySQL Connection
```bash
npm run test-mysql
```

### Test Migration Process
```bash
npm run test-migration
```

## Troubleshooting

### Common Issues

1. **Connection Refused**: Ensure MySQL is running and accessible
2. **Access Denied**: Verify database credentials in `.env` file
3. **Database Not Found**: Create the database manually if needed:
   ```sql
   CREATE DATABASE project_management;
   ```

### Rollback Plan
If you need to rollback to SQLite:
1. Restore the original [config/database.js](file:///Volumes/mac/flutter_project/project_managemenr/backend/config/database.js) file
2. Restore the original route files
3. Update `.env` to disable MySQL and enable SQLite

## Verification

After migration, verify that:
1. All data has been transferred correctly
2. All application features work as expected
3. Performance is acceptable
4. No errors appear in the logs

## Additional Notes

- The migration process preserves all existing data and relationships
- The application now uses MySQL as the primary database
- SQLite-specific code has been removed or updated for MySQL compatibility
- All existing functionality should remain unchanged