const { executeQuery } = require('../config/database');

async function addFcmTokenColumn() {
  try {
    console.log('Adding FCM token column to users table...');
    
    // Check if column already exists
    const columnsResult = await executeQuery(
      "SELECT COLUMN_NAME as name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'users' AND COLUMN_NAME = 'fcm_token'"
    );
    
    if (columnsResult.length > 0) {
      console.log('FCM token column already exists');
      return;
    }
    
    // Add the column
    await executeQuery(
      'ALTER TABLE users ADD COLUMN fcm_token VARCHAR(500) DEFAULT NULL'
    );
    
    console.log('Successfully added FCM token column to users table');
  } catch (error) {
    console.error('Error adding FCM token column:', error);
  }
}

// Run the migration
if (require.main === module) {
  addFcmTokenColumn().then(() => {
    process.exit(0);
  }).catch((error) => {
    console.error('Migration failed:', error);
    process.exit(1);
  });
}

module.exports = addFcmTokenColumn;