const sqlite = require('../config/sqlite');
const fs = require('fs');
const path = require('path');

const resetDatabase = async () => {
  try {
    console.log('🔄 Starting database reset...');
    
    // Remove existing database file
    const dbPath = path.join(__dirname, '..', 'database.sqlite');
    if (fs.existsSync(dbPath)) {
      fs.unlinkSync(dbPath);
      console.log('✅ Existing database file removed');
    }
    
    // Initialize new database
    await sqlite.initDatabase();
    console.log('✅ Database reset completed successfully');
    
    // Close database connection
    await sqlite.closeDatabase();
    console.log('✅ Database connection closed');
    
  } catch (error) {
    console.error('❌ Database reset failed:', error.message);
    process.exit(1);
  }
};

// Run the reset if this script is executed directly
if (require.main === module) {
  resetDatabase()
    .then(() => {
      console.log('🎉 Database reset completed successfully!');
      process.exit(0);
    })
    .catch((error) => {
      console.error('💥 Database reset failed:', error.message);
      process.exit(1);
    });
}

module.exports = { resetDatabase };