const { executeQuery } = require('./config/database');

async function testConnection() {
  try {
    console.log('🔍 Testing database connection...');
    
    // Test query to get all users
    const users = await executeQuery('SELECT * FROM users');
    console.log(`📊 Found ${users.length} users in the database:`);
    console.log(users);
    
    // Test query to find specific user
    const specificUser = await executeQuery('SELECT * FROM users WHERE phone_number = ?', ['12567890']);
    console.log(`📱 Found ${specificUser.length} users with phone number 12567890:`);
    console.log(specificUser);
    
    // Test query to check database name
    const dbName = await executeQuery('SELECT DATABASE() as db_name');
    console.log(`📂 Current database:`, dbName[0]);
    
  } catch (error) {
    console.error('❌ Error:', error.message);
  }
}

testConnection();